import matplotlib.pyplot as plt
import pandas as pd
import matplotlib.ticker as ticker
import pandas as pd
import numpy as np
import os

b2a=0.52917725  
dir = os.getcwd()

data_siesta = np.genfromtxt('h-BN.bands.dat') 


k = data_siesta[:,0]
E = data_siesta[:,1]

plt.plot(k,E,'k.',markersize=0.5, label='siesta', lw =0.1 )


plt.xlabel('k-points')
plt.ylabel('Energy (eV)')

plt.legend()

points = np.array(([
0.000000 ,
0.884340 ,
1.326512 ,
2.093138 
]
))

for i in range(len(points)):
    plt.axvline(points[i],c ='k', linestyle='--', lw = 0.5 )
plt.axhline(-3.9818,c ='k', linestyle=':', lw = 0.5 )

plt.xticks(points, ("Gamma", "K", "M", "Gamma"))

plt.ylim(ymin=-30, ymax=5)

plt.savefig('bands.png', dpi = 200)
