C
c $Id: spliq.f,v 1.2 1997/05/22 17:32:32 wdpgaara Exp $
c
c $Log: spliq.f,v $
c Revision 1.2  1997/05/22 17:32:32  wdpgaara
c Moving from RCSfiles to ATM_1_0
c
c Revision 1.1.1.1  1997/01/07 08:38:55  wdpgaara
c Froyen-Troullier-Martins-AG atom code
c
c Revision 1.1  1991/12/14  00:34:49  alberto
c Initial revision
c
      subroutine spliq(x,y,yp,ypp,n,xlo,xup,nup,ans,ierr)
C
C
C     SANDIA MATHEMATICAL PROGRAM LIBRARY
C     APPLIED MATHEMATICS DIVISION 2613
C     SANDIA LABORATORIES
C     ALBUQUERQUE, NEW MEXICO  87185
C     CONTROL DATA 6600/7600  VERSION 7.2  MAY 1978
C  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C                    ISSUED BY SANDIA LABORATORIES
C  *                   A PRIME CONTRACTOR TO THE
C  *                UNITED STATES DEPARTMENT OF ENERGY
C  * * * * * * * * * * * * * * * NOTICE  * * * * * * * * * * * * * * *
C  * THIS REPORT WAS PREPARED AS AN ACCOUNT OF WORK SPONSORED BY THE
C  * UNITED STATES GOVERNMENT.  NEITHER THE UNITED STATES NOR THE
C  * UNITED STATES DEPARTMENT OF ENERGY NOR ANY OF THEIR EMPLOYEES,
C  * NOR ANY OF THEIR CONTRACTORS, SUBCONTRACTORS, OR THEIR EMPLOYEES
C  * MAKES ANY WARRANTY, EXPRESS OR IMPLIED, OR ASSUMES ANY LEGAL
C  * LIABILITY OR RESPONSIBILITY FOR THE ACCURACY, COMPLETENESS OR
C  * USEFULNESS OF ANY INFORMATION, APPARATUS, PRODUCT OR PROCESS
C  * DISCLOSED, OR REPRESENTS THAT ITS USE WOULD NOT INFRINGE
C  * OWNED RIGHTS.
C  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C  * THE PRIMARY DOCUMENT FOR THE LIBRARY OF WHICH THIS ROUTINE IS
C  * PART IS SAND77-1441.
C  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C
C     THIS ROUTINE WAS WRITTEN BY M. K. GORDON
C
C     ABSTRACT
C
C     SUBROUTINE SPLIQ INTEGRATES A CUBIC SPLINE (GENERATED BY
C     SPLIFT, SMOO, ETC.) ON THE INTERVALS (XLO,XUP(I)), WHERE XUP
C     IS A SEQUENCE OF UPPER LIMITS ON THE INTERVALS OF INTEGRATION.
C     THE ONLY RESTRICTIONS ON XLO AND XUP(*) ARE
C                XLO .LT. XUP(1),
C                XUP(I) .LE. XUP(I+1)   FOR EACH I .
C     ENDPOINTS BEYOND THE SPAN OF ABSCISSAS ARE ALLOWED.
C     THE SPLINE OVER THE INTERVAL (X(I),X(I+1)) IS REGARDED
C     AS A CUBIC POLYNOMIAL EXPANDED ABOUT X(I) AND IS INTEGRATED
C     ANALYTICALLY.
C
C     DESCRIPTION OF ARGUMENTS
C         THE USER MUST DIMENSION ALL ARRAYS APPEARING IN THE CALL LIST
C         E.G.  X(N), Y(N), YP(N), YPP(N), XUP(NUP), ANS(NUP)
C
C      --INPUT--
C
C        X    - ARRAY OF ABSCISSAS (IN INCREASING ORDER) THAT DEFINE TH
C               SPLINE.  USUALLY X IS THE SAME AS X IN SPLIFT OR SMOO.
C        Y    - ARRAY OF ORDINATES THAT DEFINE THE SPLINE.  USUALLY Y I
C               THE SAME AS Y IN SPLIFT OR AS R IN SMOO.
C        YP   - ARRAY OF FIRST DERIVATIVES OF THE SPLINE AT ABSCISSAS.
C               USUALLY YP IS THE SAME AS YP IN SPLIFT OR R1 IN SMOO.
C        YPP  - ARRAY OF SECOND DERIVATIVES THAT DEFINE THE SPLINE.
C               USUALLY YPP IS THE SAME AS YPP IN SPLIFT OR R2 IN SMOO.
C        N    - THE NUMBER OF DATA POINTS THAT DEFINE THE SPLINE.
C        XLO  - LEFT ENDPOINT OF INTEGRATION INTERVALS.
C        XUP  - RIGHT ENDPOINT OR ARRAY OF RIGHT ENDPOINTS OF
C               INTEGRATION INTERVALS IN ASCENDING ORDER.
C        NUP  - THE NUMBER OF RIGHT ENDPOINTS.  IF NUP IS GREATER THAN
C               1, THEN XUP AND ANS MUST BE DIMENSIONED AT LEAST NUP.
C
C      --OUTPUT--
C
C        ANS -- ARRAY OF INTEGRAL VALUES, THAT IS,
C               ANS(I) = INTEGRAL FROM XLO TO XUP(I)
C        IERR -- ERROR STATUS
C                = 1 INTEGRATION SUCCESSFUL
C                = 2 IMPROPER INPUT - N.LT.4 OR NUP.LT.1
C                = 3 IMPROPER INPUT - ABSCISSAS NOT IN
C                        STRICTLY ASCENDING ORDER
C                = 4 IMPROPER INPUT - RIGHT ENDPOINTS XUP NOT
C                        IN ASCENDING ORDER
C                = 5 IMPROPER INPUT - XLO.GT.XUP(1)
C                = 6 INTEGRATION SUCCESSFUL BUT AT LEAST ONE ENDPOINT
C                        NOT WITHIN SPAN OF ABSCISSAS
C              ** NOTE.  ERRCHK PROCESSES DIAGNOSTICS FOR CODES 2,3,4,5
C
C   CHECK FOR IMPROPER INPUT
C
C     .. Scalar Arguments ..
      double precision xlo
      integer ierr, n, nup
C     ..
C     .. Array Arguments ..
      double precision ans(nup), x(n), xup(nup), y(n), yp(n), ypp(n)
C     ..
C     .. Local Scalars ..
      double precision hdiff, hi, hi2, hi3, hlo, hlo2, hsum, hup, hup2,
     &                 hup3, hup4, psum0, psum1, psum2, psum3, sum,
     &                 sum0, sum1, sum2, sum3
      integer i, j, m, nm1, nm2
C     ..
      ierr = 2
      if (n .lt. 4 .or. nup .lt. 1) then
c
         return
c
      end if
      nm1 = n - 1
      nm2 = n - 2
      ierr = 3
      do 10 i = 1, nm1
         if (x(i) .ge. x(i+1)) then
c
            return
c
         end if
   10 continue
      if (nup .ne. 1) then
         ierr = 4
         do 20 i = 2, nup
            if (xup(i-1) .gt. xup(i)) then
c
               return
c
            end if
   20    continue
      end if
      ierr = 5
      if (xlo .gt. xup(1)) then
c
         return
c
      end if
      ierr = 1
      if (xlo .lt. x(1) .or. xup(nup) .gt. x(n)) ierr = 6
C
C   LOCATE XLO IN INTERVAL (X(I),X(I+1))
C
      do 30 i = 1, nm2
         if (xlo .lt. x(i+1)) go to 40
   30 continue
      i = nm1
   40 continue
      hlo = xlo - x(i)
      hlo2 = hlo*hlo
      hi = x(i+1) - x(i)
      hi2 = hi*hi
      do 50 j = 1, nup
         if (xup(j) .gt. x(i+1) .and. xlo .lt. x(nm1)) go to 60
C
C   COMPUTE SPECIAL CASES OF XUP IN INTERVAL WITH XLO
C
         hup = xup(j) - x(i)
         hsum = hup + hlo
         hdiff = hup - hlo
         hup2 = hup*hup
         sum = (ypp(i+1)-ypp(i))*hsum*hdiff*(hup2+hlo2)/(24*hi)
         sum = sum + ypp(i)*hdiff*(hup2+hlo*hup+hlo2)/6
         sum = sum + yp(i)*hdiff*hsum/2
         sum = sum + y(i)*hdiff
         ans(j) = sum
   50 continue
c
      return
C
C   COMPUTE INTEGRAL BETWEEN XLO AND X(I+1) AS FOUR TERMS IN TAYLOR
C   POLYNOMIAL AND ADVANCE I TO I+1
C
   60 continue
      hdiff = hi - hlo
      hsum = hi + hlo
      sum0 = y(i)*hdiff
      sum1 = yp(i)*hdiff*hsum
      sum2 = ypp(i)*hdiff*(hi2+hi*hlo+hlo2)
      sum3 = (ypp(i+1)-ypp(i))*hdiff*hsum*(hi2+hlo2)/hi
      i = i + 1
C
C   LOCATE EACH XUP(M) IN INTERVAL (X(I),X(I+1))
C
      do 90 m = j, nup
   70    continue
         if (xup(m) .lt. x(i+1) .or. i .eq. nm1) go to 80
C
C   AUGMENT INTEGRAL BETWEEN ABSCISSAS TO INCLUDE INTERVAL
C   (X(I),X(I+1)) AND ADVANCE I TO I+1
C
         hi = x(i+1) - x(i)
         hi2 = hi*hi
         hi3 = hi2*hi
         sum0 = sum0 + y(i)*hi
         sum1 = sum1 + yp(i)*hi2
         sum2 = sum2 + ypp(i)*hi3
         sum3 = sum3 + (ypp(i+1)-ypp(i))*hi3
         i = i + 1
c
         go to 70
C
C   INTEGRAL BETWEEN X(I) AND XUP(M) IS ZERO
C
   80    continue
         if (xup(m) .ne. x(i)) then
C
C   COMPUTE INTEGRAL BETWEEN X(I) AND XUP(M) AND EVALUATE
C   TAYLOR POLYNOMIAL IN REVERSE ORDER
C
            hup = xup(m) - x(i)
            hup2 = hup*hup
            hup3 = hup2*hup
            hup4 = hup3*hup
            hi = x(i+1) - x(i)
            psum0 = y(i)*hup
            psum1 = yp(i)*hup2
            psum2 = ypp(i)*hup3
            psum3 = (ypp(i+1)-ypp(i))*hup4/hi
            sum = (sum3+psum3)/24 + (sum2+psum2)/6
            sum = sum + (sum1+psum1)/2
            sum = sum + (sum0+psum0)
         else
            sum = ((sum3/24+sum2/6)+sum1/2) + sum0
         end if
         ans(m) = sum
   90 continue
c
      return
c
      end
