! 
! This file is part of the SIESTA package.
!
! Copyright (c) Fundacion General Universidad Autonoma de Madrid:
! E.Artacho, J.Gale, A.Garcia, J.Junquera, P.Ordejon, D.Sanchez-Portal
! and J.M.Soler, 1996-2006.
! 
! Use of this software constitutes agreement with the full conditions
! given in the SIESTA license, as signed by all legitimate users.
!
      subroutine uncell(rv,a,b,c,alpha,beta,gamma)
      implicit real*8(a-h,o-z)
      include 'constants'
      dimension rv(3,3),temp(6)
C
C  Convert cell vectors to parameters
C
C  Julian Gale, April 1992
C
      do i=1,3
        temp(i)=0.0d0
        do j=1,3
          temp(i)=temp(i)+rv(j,i)**2
        enddo
        temp(i)=sqrt(temp(i))
      enddo
      a=temp(1)
      b=temp(2)
      c=temp(3)
      do i=1,3
        temp(3+i)=0.0d0
      enddo
      do j=1,3
        temp(4)=temp(4)+rv(j,2)*rv(j,3)
        temp(5)=temp(5)+rv(j,1)*rv(j,3)
        temp(6)=temp(6)+rv(j,1)*rv(j,2)
      enddo
      temp(4)=temp(4)/(temp(2)*temp(3))
      temp(5)=temp(5)/(temp(1)*temp(3))
      temp(6)=temp(6)/(temp(1)*temp(2))
      alpha=radtodeg*acos(temp(4))
      beta=radtodeg*acos(temp(5))
      gamma=radtodeg*acos(temp(6))
C
C  Avoid round off errors for 90.0 and 120.0 degrees
C
      if (abs(alpha-90.0).lt.0.00001) alpha=90.0
      if (abs(alpha-120.0).lt.0.00001) alpha=120.0
      if (abs(beta-90.0).lt.0.00001) beta=90.0
      if (abs(beta-120.0).lt.0.00001) beta=120.0
      if (abs(gamma-90.0).lt.0.00001) gamma=90.0
      if (abs(gamma-120.0).lt.0.00001) gamma=120.0
      return
      end
