! 
! This file is part of the SIESTA package.
!
! Copyright (c) Fundacion General Universidad Autonoma de Madrid:
! E.Artacho, J.Gale, A.Garcia, J.Junquera, P.Ordejon, D.Sanchez-Portal
! and J.M.Soler, 1996-2006.
! 
! Use of this software constitutes agreement with the full conditions
! given in the SIESTA license, as signed by all legitimate users.
!
      
      subroutine spin_init(nspin)
      
      use precision
      use parallel,        only : IOnode
      use m_fdf_global,    only : fdf_global_get
      use m_non_collinear, only : SPpol,   NonCol
      use m_non_collinear, only : NumSpin, MColl
      
      implicit none
      
      integer, intent(out)  :: nspin    ! Spin polarization
      
      call fdf_global_get(SPpol,    'SpinPolarized',   .false.)
      call fdf_global_get(NonCol,   'NonCollinearSpin',.false.)
      
      if (NonCol) then
         nspin     = 4
         NumSpin   = 1
         MColl     = 2
         NonCol    = .true.
         SPpol     = .false.
      elseif (SPpol) then
         nspin     = 2
         NumSpin   = nspin
         MColl     = 1
         NonCol    = .false.
         SPpol     = .true.
      else 
         nspin     = 1
         NumSpin   = nspin
         MColl     = 1
         NonCol    = .false.
         SPpol     = .false.
      endif
      
      if (ionode) then
        write(6,'(a,4x,l1)') 
     .        'redata: SpinPolarized run                = ',SPpol
        write(6,'(a,4x,l1)') 
     .        'redata: Non-Collinear-spin run           = ',NonCol
        write(6,'(a,4x,i1)') 
     .        'redata: Number of spin components        = ',nspin
      end if

      end
      
