! 
! This file is part of the SIESTA package.
!
! Copyright (c) Fundacion General Universidad Autonoma de Madrid:
! E.Artacho, J.Gale, A.Garcia, J.Junquera, P.Ordejon, D.Sanchez-Portal
! and J.M.Soler, 1996-2006.
! 
! Use of this software constitutes agreement with the full conditions
! given in the SIESTA license, as signed by all legitimate users.
!
      subroutine cart2frac(na,xc,yc,zc,rv,xyzfrac)
C
C  Converts Cartesian coordinates to fractional coordinates
C
C  On entry : 
C
C  na            = number of atoms
C  xc(na)        = Cartesian X coordinate
C  yc(na)        = Cartesian Y coordinate
C  zc(na)        = Cartesian Z coordinate
C  rv(3,3)       = cell vectors
C
C  On exit : 
C
C  xyzfrac(3,na) = fractional X coordinate
C
C  Julian Gale, NRI, Curtin University, May 2004
C
      implicit none
C
C  Passed variables
C
      integer, intent(in)     :: na
      real*8,  intent(inout)  :: xc(na)
      real*8,  intent(inout)  :: yc(na)
      real*8,  intent(inout)  :: zc(na)
      real*8,  intent(out)    :: xyzfrac(3,na)
      real*8,  intent(in)     :: rv(3,3)
C
C  Local variables
C
      integer                 :: i
      real*8                  :: rmat(3,3)
C
C  Copy lattice vectors to scratch array
C
      do i = 1,3
        rmat(1,i) = rv(1,i)
        rmat(2,i) = rv(2,i)
        rmat(3,i) = rv(3,i)
      enddo
C
C  Copy Cartesian coordinates to fractional array
C
      do i = 1,na
        xyzfrac(1,i) = xc(i)
        xyzfrac(2,i) = yc(i)
        xyzfrac(3,i) = zc(i)
      enddo
C
C  Convert cartesian coordinates to fractional for 3D case
C
      call gaussxyz(na,rmat,xyzfrac)
C
C  Place fractional coordinates in the range 0 to 1
C
      do i = 1,na
        xyzfrac(1,i) = dmod(xyzfrac(1,i)+10.0d0,1.0d0)
        xyzfrac(2,i) = dmod(xyzfrac(2,i)+10.0d0,1.0d0)
        xyzfrac(3,i) = dmod(xyzfrac(3,i)+10.0d0,1.0d0)
      enddo
C
C  Convert fractional back to Cartesian to place within cell
C
      do i = 1,na
        xc(i) = xyzfrac(1,i)*rv(1,1) + 
     .          xyzfrac(2,i)*rv(1,2) + 
     .          xyzfrac(3,i)*rv(1,3)
        yc(i) = xyzfrac(1,i)*rv(2,1) + 
     .          xyzfrac(2,i)*rv(2,2) + 
     .          xyzfrac(3,i)*rv(2,3)
        zc(i) = xyzfrac(1,i)*rv(3,1) + 
     .          xyzfrac(2,i)*rv(3,2) + 
     .          xyzfrac(3,i)*rv(3,3)
      enddo
C
      return
      end
C
      subroutine gaussxyz(m,a,xf)
C
C  Invert matrix A by Gaussian elimination and apply to
C  multiple vectors x
C
      use sys, only : die
      implicit none
C
C  Passed variables
C
      integer, intent(in)     :: m
      real*8,  intent(inout)  :: a(3,3)
      real*8,  intent(inout)  :: xf(3,m)
C
C  Local variables
C
      integer                 :: i
      integer                 :: ie
      integer                 :: in
      integer                 :: ix
      integer                 :: j
      integer                 :: k
      integer                 :: kk
      real*8                  :: delt
      real*8                  :: u
      real*8                  :: x
C
      delt = 1.0d-10
      do k = 1,2
        u = abs(a(k,k))
        kk = k + 1
        in = k
C
C  Search for index in of maximum pivot value
C      
        do i = kk,3
          if (abs(a(i,k)).gt.u) then
            u = abs(a(i,k))
            in = i
          endif
        enddo
        if (k.ne.in) then
C
C  Interchange rows k and index in
C
          do j = k,3
            x = a(k,j)
            a(k,j) = a(in,j)
            a(in,j) = x
          enddo
          do j = 1,m
            x = xf(k,j)
            xf(k,j) = xf(in,j)
            xf(in,j) = x
          enddo
        endif
C
C  Check to see if pivot value is too small
C
        if (u.lt.delt) then
          call die('Cell matrix is singular')
        endif
C
C  Forward elimination step
C
        do j = kk,3
          do i = kk,3
            a(i,j) = a(i,j) - a(i,k)*a(k,j)/a(k,k)
          enddo
        enddo
        do j = 1,m
          do i = kk,3
            xf(i,j) = xf(i,j) - a(i,k)*xf(k,j)/a(k,k)
          enddo
        enddo
      enddo
      if (abs(a(3,3)).lt.delt) then
        call die('Cell matrix is singular')
      endif
C
C  Back substitution
C
      do k = 1,m
        xf(3,k) = xf(3,k)/a(3,3)
      	do ie = 1,2
      	  i = 3 - ie
      	  ix = i + 1
      	  do j = ix,3
            xf(i,k) = xf(i,k) - xf(j,k)*a(i,j)
          enddo
      	  xf(i,k) = xf(i,k)/a(i,i)
        enddo
      enddo
C
      return
      end
