# 
# This file is part of the SIESTA package.
#
# Copyright (c) Fundacion General Universidad Autonoma de Madrid:
# E.Artacho, J.Gale, A.Garcia, J.Junquera, P.Ordejon, D.Sanchez-Portal
# and J.M.Soler, 1996-2006.
# 
# Use of this software constitutes agreement with the full conditions
# given in the SIESTA license, as signed by all legitimate users.
#
SIESTA_ARCH=intel9-mkl8
#
# Intel fortran compiler 9 for linux with mkl 8 optimized blas and lapack
#
# Be sure to experiment with different optimization options.
# You have quite a number of combinations to try...
#
# Note: The -mp1 option is necessary to recover IEEE floating point precision,
#       but it sometimes leads to bad code. Use -mp instead.
#       In this released .make file, we not use the highest optimization.
#
FC=ifort
#
FFLAGS= -w -O2 -mp
FFLAGS_DEBUG= -g 
LDFLAGS= 
COMP_LIBS=
RANLIB=echo
#
NETCDF_LIBS=
NETCDF_INTERFACE=
DEFS_CDF=
#
MPI_INTERFACE=
MPI_INCLUDE=
DEFS_MPI=
#
GUIDE=/opt/intel/mkl/8.0.1/lib/32/libguide.a
LAPACK=/opt/intel/mkl/8.0.1/lib/32/libmkl_lapack.a
BLAS=/opt/intel/mkl/8.0.1/lib/32/libmkl_ia32.a
LIBS=$(LAPACK) $(BLAS)  $(GUIDE)  -lpthread -lsvml
SYS=nag
DEFS= $(DEFS_CDF) $(DEFS_MPI)
#
.F.o:
	$(FC) -c $(FFLAGS) $(INCFLAGS)  $(DEFS) $<
.f.o:
	$(FC) -c $(FFLAGS) $(INCFLAGS)   $<
.F90.o:
	$(FC) -c $(FFLAGS) $(INCFLAGS)  $(DEFS) $<
.f90.o:
	$(FC) -c $(FFLAGS) $(INCFLAGS)   $<
#








