#!/bin/bash

. ./source.sh

dir=07-PotDiff
sys=stackingfault

runTS $dir/elec elec
runTS $dir/0V $sys
runTBT $dir/0V $sys
runTS $dir/0.5V $sys
runTBT $dir/0.5V $sys

# Go in and create the diff-cube
pushd $dir
cd 0V
grid2cube < ../vh2cube.inp

cd ../0.5V
grid2cube < ../vh2cube.inp
cd ..
cubediff 0V/$sys.VH.cube 0.5V/$sys.VH.cube diff.cube
cubediff -xy 0V/$sys.VH.cube 0.5V/$sys.VH.cube diff.dat
popd
