#!/bin/bash

. ./source.sh

dir=04-ContourConv
sys=chain

runTS $dir/elec elec
runTS $dir $sys
runTBT $dir $sys

# Loop. on different number of poles
pushd $dir
source ./source.sh
for np in 4 8 12 ; do
    chg_cp $np
    runTS ./ $sys -no-DM
    runTBT ./ $sys
    mv $sys.out $sys-P-$np.out
    mv $sys.AVTRANS $sys-P-$np.AVTRANS
    rm $sys.DM
done
chg_cp 4

for nc in 20 26 32 ; do
    chg_cc $nc
    runTS ./ $sys -no-DM
    runTBT ./ $sys
    mv $sys.out $sys-C-$nc.out
    mv $sys.AVTRANS $sys-C-$nc.AVTRANS
    rm $sys.DM
done
chg_cc 20

for nl in 4 6 10 ; do
    chg_cl $nl
    runTS ./ $sys -no-DM
    runTBT ./ $sys
    mv $sys.out $sys-L-$nl.out
    mv $sys.AVTRANS $sys-L-$nl.AVTRANS
    rm $sys.DM
done
chg_cl 10
    
popd