program cube_diff
  
  implicit none

  integer, parameter :: dp = selected_real_kind(14,300)

  ! Allocate room for the grid
  real(dp), allocatable :: grid1(:), grid2(:), g(:,:,:)

  integer :: i, iarg, narg
  character(len=200) :: cube1, cube2, dcube, arg
  integer :: mesh(3)
  real(dp) :: cell(3,3), rtmp(3)
  integer :: na
  integer, allocatable :: izat(:)
  real(dp), allocatable :: xa(:,:)

  ! Loop variables
  logical :: xy 
  integer :: ix, iy, iz
  integer, parameter :: u1 = 14, u2 = 15, ud = 16, udxy = 17

  cube1 = ' '
  cube2 = ' '
  dcube = ' '
  xy = .false.

  ! Grab number of arguments
  narg = command_argument_count()
  iarg = 1
  do while( iarg <= narg )
     arg = ' '
     call get_command_argument(iarg,arg)
     select case ( arg )
     case ( '-cube-1' )
        iarg = iarg + 1
        call get_command_argument(iarg,arg)
        cube1 = arg
     case ( '-cube-2' )
        iarg = iarg + 1
        call get_command_argument(iarg,arg)
        cube2 = arg
     case ( '-xy' )
        xy = .true.
        print *,'Will project to the plane.'
     case ( '-o' )
        iarg = iarg + 1
        call get_command_argument(iarg,arg)
        dcube = arg
     case default
        if ( len_trim(cube1) == 0 ) then
           cube1 = arg
        else if ( len_trim(cube2) == 0 ) then
           cube2 = arg
        else if ( len_trim(dcube) == 0 ) then
           dcube = arg
        end if
     end select
     iarg = iarg + 1
  end do

  if ( len_trim(dcube) == 0 ) then
     dcube = 'diff.cube'
  end if
  
  print '(6a)','Will do ',trim(dcube),' = ',trim(cube2),' - ',trim(cube1)
  
  open(unit=u1, file=cube1, form='formatted', status='old')
  open(unit=u2, file=cube2, form='formatted', status='old')
  open(unit=ud, file=dcube, form='formatted', status='replace')

  ! Read in header of u1
  read(u1,'(a)') arg
  read(u1,*)  ! same
  read(u1,'(i5,4f12.6)') na,cell(:,1)
  read(u2,*) ! same
  read(u2,*) ! same
  read(u2,'(i5,4f12.6)') ix,cell(:,1)
  if ( ix /= na ) stop 'Cube files do not have the same number of atoms'
  allocate(xa(3,na),izat(na))
  do i = 1 , 3
     read(u1,'(i5,4f12.6)') mesh(i),cell(:,i)
     read(u2,'(i5,4f12.6)') ix,rtmp(:)
     if ( sum(abs(rtmp-cell(:,i))) > 1.e-6_dp ) then
        stop ' Cube files do not have same cell size...'
     end if
     if ( mesh(i) /= ix ) then
        stop ' Cube files do not have same cell size...'
     end if
  end do

  do i = 1 , na
     read(u1,'(i5,4f12.6)') izat(i),rtmp(1),xa(:,i)
     read(u2,'(i5,4f12.6)') ! do not save it (do not check it...)
  end do

  ! Allocate the grid
  if ( xy ) then
     ! We also save the single line
     write(ud,'(a,a15,tr1,a15)') '#','z [Ang]','V'

     allocate(grid1(mesh(3)*mesh(2)*mesh(1)))
     allocate(grid2(mesh(3)*mesh(2)*mesh(1)))
     iz = 0
     do ix = 1 , mesh(1)
        do iy = 1 , mesh(2)
           read(u1,'(6e13.5)')  grid1(iz+1:iz+mesh(3))
           read(u2,'(6e13.5)')  grid2(iz+1:iz+mesh(3))
           iz = iz + mesh(3)
        end do
     end do
     grid2 = grid2 - grid1
     deallocate(grid1)
     allocate(g(mesh(3),mesh(2),mesh(1)))
     allocate(grid1(mesh(3)))
     g = reshape(grid2,shape=(/mesh(3),mesh(2),mesh(1)/))
     grid1(:) = sum(sum(g,DIM=2),DIM=2) / (mesh(2)*mesh(1))
     deallocate(grid2)
     do iz = 1 , mesh(3)
        write(ud,'(2(tr1,e15.6))') cell(3,3) * (iz-.5_dp) * 0.529177249_dp, grid1(iz)
     end do
     deallocate(g)
     allocate(grid2(1))
  else
     write(ud,'(a)') 'Diff cube 1: '//trim(cube1)
     write(ud,'(a)') 'Diff cube 2: '//trim(cube2)
     write(ud,'(i5,4f12.6)') na, 0.0,0.0,0.0
     do i = 1 , 3
        write(ud,'(i5,4f12.6)') mesh(i),cell(:,i)
     end do
     do i = 1 , na
        write(ud,'(i5,4f12.6)') izat(i),0.0,xa(:,i)
     end do

     allocate(grid1(mesh(3)),grid2(mesh(3)))
     do ix = 1 , mesh(1)
        do iy = 1 , mesh(2)
           read(u1,'(6e13.5)')  grid1(:)
           read(u2,'(6e13.5)')  grid2(:)
           grid2(:) = grid2(:) - grid1(:)
           write(ud,'(6e13.5)') grid2
        end do
     end do
  end if

  close(u1)
  close(u2)
  close(ud)

  deallocate(xa,izat,grid1,grid2)

end program cube_diff
     




