
# Functions for changing number of contour points

FILE=chain.fdf

_chg() {
   local fdf="$1" ; shift
   local f=$FILE
   local c=$1 ; shift
   [ $# -gt 0 ] && f=$1
   sed -i -e "s:$fdf .*:$fdf $c:gi" $f
}

chg_cc() {
   _chg TS.ComplexContour.NCircle $@
}
chg_cl() {
   _chg TS.ComplexContour.NLine $@
}
chg_cp() {
   _chg TS.ComplexContour.NPoles $@
}

echo "You are now given the possibility to run three commands:"
echo "   chg_cc <integer>:"
echo "             changes the number of circle contour points"
echo "             in file 'chain.fdf' to the provided number."
echo "   chg_cl <integer>:"
echo "             changes the number of line contour points"
echo "             in file 'chain.fdf' to the provided number."
echo "   chg_cp <integer>:"
echo "             changes the number of pole contour points"
echo "             in file 'chain.fdf' to the provided number."
echo ""
echo "All commands actually take an optional file as a further parameter"
echo "if you want to do it on another file:"
echo "  chg_cc 20 test.fdf"
echo "will change the number of circle contours in file test.fdf"


