 program wcml_properties_example

! you need to say that you are going to use the CML output routines:
   use FoX_wcml

   implicit none

! You need to declare a CML file variable.
  type(xmlf_t) :: myfile

  character(len=*), parameter :: filename = "propertiesCMLoutput.xml"
  integer :: i = 5
  real :: pi = 3.141
  double precision :: e = 2.72
  complex :: c = (3.0, 4.0)

  character(len=2) :: elements(3)
  integer :: array_i(3) = (/1, 3, 5/)
  real :: array_r(3) = (/1.0, 2.72, 3.141/)
  double precision :: array_d(3) = (/1.0d0, 2.72d0, 3.141d0/)
  complex :: array_c(3) = (/(1.0, 1.0), (2.0, 2.0), (3.0, 3.0)/)

  elements(1) = "Ca"
  elements(2) = "Mg"
  elements(3) = "O"

! open the file
  call cmlBeginFile(myfile, filename=filename, unit=-1)

! start CML output
  call cmlStartCml(myfile)

! start a list of properties
  call cmlStartPropertyList(myfile, title="Scalar properties")
! output a series of properties of different types
  call cmlAddProperty(myfile, title="filename", value=filename)
! note that if the property is numerical, it needs units.
  call cmlAddProperty(myfile, title="An integer",                value=i, units="countable")
  call cmlAddProperty(myfile, title="A real number",             value=pi, units="metres")
  call cmlAddProperty(myfile, title="A double precision number", value=e, units="kilojoules")
  call cmlAddProperty(myfile, title="A complex number",          value=c, units="milliamperes")
! and end the propertylist again
  call cmlEndPropertyList(myfile)

! Now do the same, but with arrays.
! start a list of properties
  call cmlStartPropertyList(myfile, title="Array properties")
! output a series of properties of different types
  call cmlAddProperty(myfile, title="elements", value=elements)
! note that if the property is numerical, it needs units.
  call cmlAddProperty(myfile, title="Some integers",                 value=array_i, units="countable")
  call cmlAddProperty(myfile, title="Some real numbers",             value=array_r, units="metres")
  call cmlAddProperty(myfile, title="Some double precision numbers", value=array_d, units="kilojoules")
  call cmlAddProperty(myfile, title="Some complex numbers",          value=array_c, units="milliamperes")
! and end the propertylist again
  call cmlEndPropertyList(myfile)

! End and Close
  call cmlEndCml(myfile)
  call cmlFinishFile(myfile)
 
end program wcml_properties_example
