 program wcml_molecule_example

! you need to say that you are going to use the CML output routines:
   use FoX_wcml

! You need to declare a CML file variable.
  type(xmlf_t) :: myfile

  character(len=2)  :: elements(3)
  double precision  :: coords(3,3)

  character(len=*), parameter :: filename = "moleculeCMLoutput.xml"

  data coords(1:3,1)/0.0d0, 0.0d0, 0.0d0/
  data coords(1:3,2)/0.5d0, 0.5d0, 0.5d0/
  data coords(1:3,3)/0.4d0, 0.4d0, 0.4d0/

  elements(1) = 'Ca'
  elements(2) = 'Si'
  elements(3) = 'O'

! open the file
  call cmlBeginFile(myfile, filename=filename, unit=-1)

! start CML output
  call cmlStartCml(myfile)

! Add molecule
  call cmlAddMolecule(myfile, elements=elements,coords=coords)                               

! End and Close
  call cmlEndCml(myfile)
  call cmlFinishFile(myfile)
 
end program wcml_molecule_example
