#!/usr/bin/env python

from lxml import etree

ns = {"cml":"http://www.xml-cml.org/schema"}

doc = etree.parse("siesta.xml")

allSteps = doc.xpath("//cml:module[@role='step']", ns)
numSteps = len(allSteps)

CGSteps = doc.xpath("//cml:module[@role='step' and @dictRef='CG']", ns)
numCGSteps = len(CGSteps)

CGStepIndices = doc.xpath("/cml:cml/cml:module[@role='step']/@serial", ns)

print 'There are ', numSteps, ' steps in total, of which ', numCGSteps, ' are CG steps.'
print 'The CG steps are numbered as follows:'
print CGStepIndices
